if (NOT GDAL_FOUND)
    SET(GDAL_FOUND FALSE)
    FIND_PROGRAM(GDAL_GDAL_CONFIG_EXECUTABLE NAMES gdal-config)

    IF(GDAL_GDAL_CONFIG_EXECUTABLE)
        SET(GDAL_FOUND TRUE)

        EXECUTE_PROCESS(COMMAND ${GDAL_GDAL_CONFIG_EXECUTABLE} --cflags
            OUTPUT_VARIABLE GDAL_CFLAGS)
        STRING(REPLACE "\n" "" GDAL_CFLAGS ${GDAL_CFLAGS})

        EXECUTE_PROCESS(COMMAND ${GDAL_GDAL_CONFIG_EXECUTABLE} --libs
            OUTPUT_VARIABLE GDAL_LIBRARIES)
        STRING(REPLACE "\n" "" GDAL_LIBRARIES ${GDAL_LIBRARIES})

        MARK_AS_ADVANCED(GDAL_CFLAGS GDAL_LIBRARIES)
    ENDIF()


    include(FindPackageHandleStandardArgs)
    find_package_handle_standard_args(GDAL DEFAULT_MSG GDAL_LIBRARIES)
endif()


