#include "ArgParser.hpp"
#include "ReplayGui.h"

#include <csignal>

ReplayHandler replayHandler;

void startHeadless(const ArgParser& argParser)
{
    std::signal(SIGINT, [](int sig) { replayHandler.stop(); });
    replayHandler.init(argParser.fileNames, argParser.prefix, argParser.whiteListTokens, argParser.renamings);
    replayHandler.play();

    while(replayHandler.isPlaying())
    {
        std::cout << "replaying [" << replayHandler.getCurIndex() << "/" << replayHandler.getMaxIndex()
                  << "]: " << replayHandler.getCurSamplePortName() << "\r";
    }

    std::cout << std::endl;

    replayHandler.stop();
    std::cout << "replay handler stopped" << std::endl;
}

int startGui(int argc, char* argv[], const ArgParser& argParser)
{
    QApplication a(argc, argv);
    ReplayGui gui;

    gui.initReplayHandler(argParser.fileNames, argParser.prefix, argParser.whiteListTokens, argParser.renamings);
    gui.updateTaskView();

    gui.show();
    return a.exec();
}

int main(int argc, char* argv[])
{
    ArgParser argParser;
    if(argParser.parseArguments(argc, argv))
    {
        if(argParser.headless)
        {
            startHeadless(argParser);
        }
        else
        {
            startGui(argc, argv, argParser);
        }
    }

    return 0;
}
