//
// Copyright (c) 2015, Deutsches Forschungszentrum für Künstliche Intelligenz GmbH.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
//
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#pragma once

#include <envire_core/items/Frame.hpp>
#include <envire_core/events/GraphEvent.hpp>

namespace envire { namespace core
{
    class FrameEvent : public GraphEvent
    {
    public:
        FrameEvent() = delete;

        virtual bool mergeable(const GraphEvent& event)
        {
            if(type == FRAME_ADDED && event.getType() == FRAME_REMOVED)
            {
                const FrameEvent& frame_event = dynamic_cast<const FrameEvent&>(event);
                if(frame == frame_event.frame)
                    return true;
            }
            return false;
        }

        FrameId frame;

    protected:
        explicit FrameEvent(const Type type, const FrameId& addedFrame) :
                    GraphEvent(type), frame(addedFrame){}
    };

    class FrameAddedEvent : public FrameEvent
    {
    public:
      explicit FrameAddedEvent(const FrameId& addedFrame) :
        FrameEvent(GraphEvent::FRAME_ADDED, addedFrame) {}

        GraphEvent* clone() const
        {
            return new FrameAddedEvent(frame);
        }
    };

    class FrameRemovedEvent : public FrameEvent
    {
    public:
      explicit FrameRemovedEvent(const FrameId& removedFrame) :
        FrameEvent(GraphEvent::FRAME_REMOVED, removedFrame) {}

        GraphEvent* clone() const
        {
            return new FrameRemovedEvent(frame);
        }
    };
}}
