#ifndef PROJECTION_OMNIDIRECTIONALCONFIG_HPP__
#define PROJECTION_OMNIDIRECTIONALCONFIG_HPP__

#include <vector>
#include <Eigen/Core>
#include <Eigen/Geometry>

namespace projection
{
namespace omnicam
{

class Model
{
public:
    std::vector<double> pol;    // the polynomial coefficients: pol[0] + x"pol[1] + x^2*pol[2] + ... + x^(N-1)*pol[N-1]
    std::vector<double> invpol; // the coefficients of the inverse polynomial
    double xc;         // row coordinate of the center
    double yc;         // column coordinate of the center
    double c;          // affine parameter
    double d;          // affine parameter
    double e;          // affine parameter
    size_t width;         // image width
    size_t height;        // image height
    double min_angle;      // valid minimum angle 
    double max_angle;      // valid maximum angle 

    /**
     * load a calibration file generated by OcamCalib
     */
    void loadFromFile( std::string filename );
    /**
     * transform world to camera coordinates
     * @result true if the camera coordinate is valid
     */
    bool world2cam( const Eigen::Vector3d& world, Eigen::Vector2d &cam ) const;
    /**
     * transform camera to world coordinates
     * @result true if world coordinate is valid
     */
    bool cam2world( const Eigen::Vector2d& cam, Eigen::Vector3d &world ) const;

    /**
     * @brief set the angle range for which the calibration is valid
     */
    void setAngleRange( float min, float max );

    /**
     * @brief return true if the configuration is valid
     */
    bool isValid() const;

    size_t getWidth() const;
    size_t getHeight() const;
};

struct PlanarViewConfiguration
{
    PlanarViewConfiguration()
        : azimuth(0.0), elevation(0.0), fov(M_PI*0.5) {}

    /// azimuth of the virtual pan tilt unit in rad
    double azimuth;
    /// elevation of the virtual pan til unit in rad
    double elevation;
    /// diagonal field of view in rad 
    double fov;
};

}
}

#endif
