#include "SonarWidget.h"
#include "./SonarPlot.h"
#include <iostream>

SonarWidget::SonarWidget(QWidget *parent)
    : QWidget(parent)
{
    resize(1020,670);
    
    plot = new SonarPlot(this);
    plot->setGeometry (10,10,BASE_WIDTH,BASE_HEIGHT);
    connect(this,SIGNAL(rangeChanged(int)),plot,SLOT(rangeChanged(int)));
    connect(this,SIGNAL(sonarPaletteChanged(int)),plot,SLOT(sonarPaletteChanged(int)));
    connect(this,SIGNAL(gridChanged(bool)),plot,SLOT(gridChanged(bool)));

    QPalette Pal(palette());
    Pal.setColor(QPalette::Background, plot->palette().color(QPalette::Background));
    setAutoFillBackground(true);
    setPalette(Pal);
    
    createGainComponent();
    createRangeComponent();
    createPaletteComponent();
    createGridComponent();

    show();
}

void SonarWidget::resizeEvent ( QResizeEvent * event )
{
  plot->setGeometry (10,10,width()-20,height()-70);
  lbGain->setGeometry(10,height()-70,50,20);
  slGain->setGeometry(70,height()-70,150,20);
  edGain->setGeometry(230,height()-70,50,20);
  lbRange->setGeometry(10,height()-40,50,20);
  slRange->setGeometry(70,height()-40,150,20);
  edRange->setGeometry(230,height()-40,50,20);
  lbPalette->setGeometry(width()-160,height()-40,50,20);
  comboPalette->setGeometry(width()-100,height()-40,80,20);
  lbGrid->setGeometry(width()-160,height()-70,50,20);
  boxGrid->setGeometry(width()-100,height()-70,80,20);
  QWidget::resizeEvent (event);
}

SonarWidget::~SonarWidget()
{
  if(plot){
    delete plot;
  }
}

void SonarWidget::setData(const base::samples::SonarScan scan)
{
    base::samples::Sonar sonar(scan);
    setData(sonar);
}

void SonarWidget::setData(const base::samples::Sonar sonar)
{
    plot->setData(sonar);
}

void SonarWidget::setMotorStep(const base::Angle step)
{
    plot->setMotorStep(step);
}

void SonarWidget::setGain(int value)
{
    slGain->setValue(value);
}

int SonarWidget::getGain() const
{
  return slGain->value();
}

void SonarWidget::setRange(int value)
{
    slRange->setValue(value);
}

int SonarWidget::getRange() const
{
  return slRange->value();
}

void SonarWidget::setSectorScan(bool continuous, base::Angle left, base::Angle right)
{
    plot->setSectorScan(continuous, left, right);
}

void SonarWidget::setMinRange(int value)
{
    slRange->setMinimum(value);
}

void SonarWidget::setMaxRange(int value)
{
    slRange->setMaximum(value);
}

void SonarWidget::setSonarPalette(int value)
{
  comboPalette->setCurrentIndex(value);
}

void SonarWidget::enableAutoRanging(bool value)
{
  slRange->setEnabled(!value);
}

void SonarWidget::onSlGainChanged(int value)
{
  QString str;
  str.setNum(value);
  edGain->setText(str + " %");
  gainChanged(value);
}

void SonarWidget::onSlRangeChanged(int value)
{
  QString str;
  str.setNum(value);
  edRange->setText(str + " m");
  rangeChanged(value);
}

void SonarWidget::onComboPaletteChanged(int value)
{
    sonarPaletteChanged(value);
}

void SonarWidget::onCheckboxGridChanged(bool value)
{
    gridChanged(value);
}

void SonarWidget::createGainComponent() {
    lbGain = new QLabel(this);
    lbGain->setGeometry(10, height() - 70, 50, 20);
    QPalette Pal = lbGain->palette();
    Pal.setColor(QPalette::Foreground, Qt::white);
    lbGain->setPalette(Pal);
    lbGain->setText("Gain:");
    slGain = new QSlider(Qt::Horizontal, this);
    slGain->setGeometry(70, height() - 70, 150, 20);
    slGain->setMinimum(0);
    slGain->setMaximum(100);
    slGain->setValue(50);
    edGain = new QLineEdit(this);
    edGain->setGeometry(230, height() - 70, 50, 20);
    edGain->setAlignment(Qt::AlignRight);
    Pal = edGain->palette();
    Pal.setColor(QPalette::Base, plot->palette().color(QPalette::Background));
    Pal.setColor(QPalette::Text, Qt::white);
    setAutoFillBackground(true);
    edGain->setPalette(Pal);
    edGain->setReadOnly(true);
    edGain->setText("50 %");
    connect(slGain,SIGNAL(valueChanged(int)),this,SLOT(onSlGainChanged(int)));
}

void SonarWidget::createRangeComponent() {
    lbRange = new QLabel(this);
    lbRange->setGeometry(10,height()-40,50,20);
    QPalette Pal=lbRange->palette();
    Pal.setColor(QPalette::Foreground,Qt::white);
    lbRange->setPalette(Pal);
    lbRange->setText("Range:");
    slRange = new QSlider(Qt::Horizontal, this);
    slRange->setGeometry(70,height()-40,150,20);
    slRange->setMinimum(1);
    slRange->setMaximum(150);
    slRange->setValue(5);
    edRange = new QLineEdit(this);
    edRange->setGeometry(230,height()-40,50,20);
    edRange->setAlignment(Qt::AlignRight);
    Pal=edRange->palette();
    Pal.setColor(QPalette::Base, plot->palette().color(QPalette::Background));
    Pal.setColor(QPalette::Text,Qt::white);
    setAutoFillBackground(true);
    edRange->setPalette(Pal);
    edRange->setReadOnly(true);
    edRange->setText("5 m");
    connect(slRange,SIGNAL(valueChanged(int)),this,SLOT(onSlRangeChanged(int)));
}

void SonarWidget::createPaletteComponent() {
    lbPalette = new QLabel(this);
    lbPalette->setGeometry(width()-160, height() - 40, 50, 20);
    lbPalette->setGeometry(width()-160, height() - 40, 50, 20);
    lbPalette->setText("Palette:");
    lbPalette->setStyleSheet("background-color: blue; color: white;");
    lbPalette->setAlignment(Qt::AlignRight);

    comboPalette = new QComboBox(this);
    comboPalette->setGeometry(width()-100,height()-40,80,20);
    QPalette Pal = comboPalette->palette();
    Pal.setColor(comboPalette->backgroundRole(), plot->palette().color(QPalette::Background));
    Pal.setColor(comboPalette->foregroundRole(),Qt::white);
    setAutoFillBackground(true);
    comboPalette->setPalette(Pal);
    comboPalette->insertItem(comboPalette->count()+1,"Jet");
    comboPalette->insertItem(comboPalette->count()+1,"Hot");
    comboPalette->insertItem(comboPalette->count()+1,"Gray");
    comboPalette->insertItem(comboPalette->count()+1,"Bronze");
    connect(comboPalette,SIGNAL(currentIndexChanged(int)),this,SLOT(onComboPaletteChanged(int)));
}

void SonarWidget::createGridComponent() {
    lbGrid = new QLabel(this);
    lbGrid->setGeometry(width() - 160, height() - 70, 50, 20);
    lbGrid->setText("Grid:");
    lbGrid->setAlignment(Qt::AlignRight);
    lbGrid->setStyleSheet("background-color: blue; color: white;");

    boxGrid = new QCheckBox(this);
    boxGrid->setGeometry(width() - 100, height() - 70, 20, 20);
    boxGrid->setStyleSheet("background-color: blue;");
    boxGrid->setChecked(true);
    connect(boxGrid,SIGNAL(clicked(bool)), this, SLOT(onCheckboxGridChanged(bool)));
}
