import os
import textwrap
from docutils import core

def createHeader(relPath):
    out = '''\
             <!DOCTYPE html>
             <html>
               <head>
                 <title>MARS Simulator</title>
                 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
                 <meta name="description" content="MARS is a flexible physics simulator.">
                 <meta name="author" content="MARS Project">
                 <meta name="keywords" content="MARS, simulation, physics, robotics">
                 <link rel="stylesheet" type="text/css" href="{relPath}/src/css/mars_default.css" media="all" />
               </head>
             <body>
               <div class="nav-box">
                 <h2>Navigation</h2>
                 <nav>
                   <ol>
                     <li><a href="{relPath}/mars_manual/index.html">Home</a></li>
                   </ol>
                 </nav>
               </div>
               <div id="content">
               <header>
                 <a href="{relPath}/mars_manual/index.html"><img src="{relPath}/src/images/logo_v2_wob.png" alt="MARS" /></a>
               </header>
       '''.format(relPath = relPath)
    return textwrap.dedent(out)

def createFooter():
    out = '''\
          <footer>
            <a href="http://validator.w3.org/check?uri=referer" target="_blank">
              <img src="http://www.w3.org/Icons/valid-html401"
                   alt="Valid HTML 4.01 Transitional"/>
            </a>
            <a href="http://jigsaw.w3.org/css-validator/check/referer" target="_blank">
              <img src="http://jigsaw.w3.org/css-validator/images/vcss"
                   alt="Valid CSS!"/>
            </a>
          </footer>
        </div>
      </body>
    </html>
          '''
    return textwrap.dedent(out)

def convertRstToHtml(filePath, fileName):
    # this part is rather ugly, but os.path.join() didn't work, either
    tmpPath = filePath.replace("../", "")
    tmpPath = tmpPath.replace("doc", "")
    tmpPath = tmpPath.replace("/src", "")
    if len(tmpPath) > 0 and tmpPath[0] == "/":
        tmpPath = tmpPath[1:]
    outPath = "../mars_manual/" + tmpPath
    
    relPath = constructRelativePath(outPath)
    headerString = createHeader(relPath)
    footerString = createFooter()
    inFile = open(os.path.join(filePath, fileName), "r")
    bodyString = inFile.read()
    inFile.close()
    bodyString = core.publish_parts(bodyString, writer_name='html') ['html_body']
    if not os.path.exists(outPath):
        os.makedirs(outPath)
    outFile = open(os.path.join(outPath, fileName[:-4]+".html"), "w")
    outFile.write("<!-- DO NOT EDIT THIS FILE! IT IS AUTOMATICALLY GENERATED BY rst2marshtml //-->\n")
    outFile.write(headerString)
    outFile.write(bodyString)
    outFile.write(footerString)
    outFile.close()
    print "    Converting " + filePath + "/" + fileName + " to " + os.path.join(outPath, fileName[0:-3] + "html")
    
def constructRelativePath(filePath):
    n = filePath.count("/")
    if n == 0:
        return "."
    else:
        relPath = ".."
        for i in range(n-1):
            relPath+="/.."
        return relPath

if __name__ == '__main__':

    #the following code browses through all directories and automatically converts all .rst files
    print "Converting .rst to mars/doc/*.html..."
    n = 0
    for root, dirs, files in os.walk("../../"):
        for f in files:
            if f.endswith(".rst"):
                convertRstToHtml(root, f)
                n+=1
    print "In total,", n, "files were converted."


