/***************************************************************************
  tag: The SourceWorks  Tue Sep 7 00:55:18 CEST 2010  ServiceI.cpp

                        ServiceI.cpp -  description
                           -------------------
    begin                : Tue September 07 2010
    copyright            : (C) 2010 The SourceWorks
    email                : peter@thesourceworks.com

 ***************************************************************************
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public                   *
 *   License as published by the Free Software Foundation;                 *
 *   version 2 of the License.                                             *
 *                                                                         *
 *   As a special exception, you may use this file as part of a free       *
 *   software library without restriction.  Specifically, if other files   *
 *   instantiate templates or use macros or inline functions from this     *
 *   file, or you compile this file and link it with other files to        *
 *   produce an executable, this file does not by itself cause the         *
 *   resulting executable to be covered by the GNU General Public          *
 *   License.  This exception does not however invalidate any other        *
 *   reasons why the executable file might be covered by the GNU General   *
 *   Public License.                                                       *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place,                                    *
 *   Suite 330, Boston, MA  02111-1307  USA                                *
 *                                                                         *
 ***************************************************************************/


// -*- C++ -*-
//
// $Id$

// ****  Code generated by the The ACE ORB (TAO) IDL Compiler ****
// TAO and the TAO IDL Compiler have been developed by:
//       Center for Distributed Object Computing
//       Washington University
//       St. Louis, MO
//       USA
//       http://www.cs.wustl.edu/~schmidt/doc-center.html
// and
//       Distributed Object Computing Laboratory
//       University of California at Irvine
//       Irvine, CA
//       USA
//       http://doc.ece.uci.edu/
// and
//       Institute for Software Integrated Systems
//       Vanderbilt University
//       Nashville, TN
//       USA
//       http://www.isis.vanderbilt.edu/
//
// Information about TAO is available at:
//     http://www.cs.wustl.edu/~schmidt/TAO.html

// TAO_IDL - Generated from 
// ../../../ACE_wrappers/TAO/TAO_IDL/be/be_codegen.cpp:1196

#include "ServiceI.h"
#include "CorbaLib.hpp"

using namespace RTT;
using namespace RTT::detail;

// Implementation skeleton constructor
RTT_corba_CService_i::RTT_corba_CService_i ( RTT::Service::shared_ptr service, PortableServer::POA_ptr poa)
    : RTT_corba_CConfigurationInterface_i( service.get(), PortableServer::POA::_duplicate( poa) ), 
      RTT_corba_COperationInterface_i( service.get(), PortableServer::POA::_duplicate( poa) ),
      RTT::corba::CDataFlowInterface_i( service.get(), PortableServer::POA::_duplicate( poa) ),
      mpoa(poa), mservice(service)
{
}

// Implementation skeleton destructor
RTT_corba_CService_i::~RTT_corba_CService_i (void)
{
}

PortableServer::POA_ptr RTT_corba_CService_i::_default_POA()
{
    return PortableServer::POA::_duplicate(mpoa);
}

char * RTT_corba_CService_i::getName (
    void)
{
    Service::shared_ptr service(mservice);
    return CORBA::string_dup( service->getName().c_str() );
}

char * RTT_corba_CService_i::getServiceDescription (
    void)
{
    Service::shared_ptr service(mservice);
    return CORBA::string_dup( service->doc().c_str() );
}

::RTT::corba::CService::CProviderNames * RTT_corba_CService_i::getProviderNames (
    void)
{
    Service::shared_ptr service(mservice);
    Service::ProviderNames names = service->getProviderNames();
    ::RTT::corba::CService::CProviderNames_var result = new ::RTT::corba::CService::CProviderNames();
    result->length( names.size() );
    for (unsigned int i=0; i != names.size(); ++i )
        result[i] = CORBA::string_dup( names[i].c_str() );

    return result._retn();
}

::RTT::corba::CService_ptr RTT_corba_CService_i::getService (
    const char * service_name)
{
    std::string svc(service_name);
    if ( svc == "this" )
        return _this();

    Service::shared_ptr service(mservice);
    Service::shared_ptr provider = service->getService(svc);
    if ( !provider )
    	return RTT::corba::CService::_nil();

    // Creates service requester
    if ( mservs.find(svc) == mservs.end() ) {
        log(Debug) << "Creating CService for "<< service_name <<endlog();

        RTT_corba_CService_i* serv_i;
        RTT::corba::CService_ptr serv;
        serv_i = new RTT_corba_CService_i( provider, mpoa );
        serv = serv_i->activate_this();
        mservs[svc] = std::pair<RTT::corba::CService_var,PortableServer::ServantBase_var>(serv, serv_i);
    }
    // Now return it.
    return RTT::corba::CService::_duplicate( mservs[svc].first.in() );
}

::CORBA::Boolean RTT_corba_CService_i::hasService (
    const char * name)
{
    Service::shared_ptr service(mservice);
    return service->hasService( name );
}

::RTT::corba::CServiceDescription * RTT_corba_CService_i::getCServiceDescription (
    void)
{
    Service::shared_ptr service(mservice);
    ::RTT::corba::CServiceDescription_var d = new ::RTT::corba::CServiceDescription;
    unsigned int j = 0;

    d->name = getName();
    d->description = getServiceDescription();

    ::RTT::corba::COperationInterface::COperationDescriptions_var operations = getOperations();
    d->operations = operations;

    ::RTT::corba::CDataFlowInterface::CPortDescriptions_var ports = getPortDescriptions();
    d->ports = ports;

    ::RTT::corba::CConfigurationInterface::CPropertyNames_var properties = getPropertyList();
    d->properties = properties;

    ::RTT::corba::CConfigurationInterface::CAttributeNames_var attributes = getAttributeList();
    d->attributes = attributes;

    // Child services
    Service::ProviderNames providers = service->getProviderNames();
    d->children.length( providers.size() );
    d->children_descriptions.length( providers.size() );
    j = 0;
    for (unsigned int i=0; i != providers.size(); ++i )
    {
        if (providers[i] == "this") continue;

        // omit PortObject services
        if (service->getPort(providers[i])) continue;

        ::RTT::corba::CService_ptr provider = getService(providers[i].c_str());
        Servants::const_iterator it = mservs.find(providers[i]);
        if (it != mservs.end()) {
            RTT_corba_CService_i *child = dynamic_cast<RTT_corba_CService_i *>(it->second.second.in());
            if (child) {
                ::RTT::corba::CServiceDescription_var child_description = child->getCServiceDescription();
                d->children[j] = provider;
                d->children_descriptions[j] = child_description;
                j++;
            }
            break;
        }
    }
    d->children.length(j); // set real size
    d->children_descriptions.length(j); // set real size

    return d._retn();
}
