/***************************************************************************
  tag: The SourceWorks  Tue Sep 7 00:55:18 CEST 2010  ConfigurationInterfaceI.cpp

                        ConfigurationInterfaceI.cpp -  description
                           -------------------
    begin                : Tue September 07 2010
    copyright            : (C) 2010 The SourceWorks
    email                : peter@thesourceworks.com

 ***************************************************************************
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public                   *
 *   License as published by the Free Software Foundation;                 *
 *   version 2 of the License.                                             *
 *                                                                         *
 *   As a special exception, you may use this file as part of a free       *
 *   software library without restriction.  Specifically, if other files   *
 *   instantiate templates or use macros or inline functions from this     *
 *   file, or you compile this file and link it with other files to        *
 *   produce an executable, this file does not by itself cause the         *
 *   resulting executable to be covered by the GNU General Public          *
 *   License.  This exception does not however invalidate any other        *
 *   reasons why the executable file might be covered by the GNU General   *
 *   Public License.                                                       *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place,                                    *
 *   Suite 330, Boston, MA  02111-1307  USA                                *
 *                                                                         *
 ***************************************************************************/


// -*- C++ -*-
//
// $Id$

// ****  Code generated by the The ACE ORB (TAO) IDL Compiler ****
// TAO and the TAO IDL Compiler have been developed by:
//       Center for Distributed Object Computing
//       Washington University
//       St. Louis, MO
//       USA
//       http://www.cs.wustl.edu/~schmidt/doc-center.html
// and
//       Distributed Object Computing Laboratory
//       University of California at Irvine
//       Irvine, CA
//       USA
//       http://doc.ece.uci.edu/
// and
//       Institute for Software Integrated Systems
//       Vanderbilt University
//       Nashville, TN
//       USA
//       http://www.isis.vanderbilt.edu/
//
// Information about TAO is available at:
//     http://www.cs.wustl.edu/~schmidt/TAO.html

// TAO_IDL - Generated from
// ../../../ACE_wrappers/TAO/TAO_IDL/be/be_codegen.cpp:1196

#include "ConfigurationInterfaceI.h"
#include "ConfigurationInterfaceC.h"
#include "CorbaLib.hpp"
#include "CorbaTypeTransporter.hpp"
#include <vector>
#include "../../PropertyBag.hpp"
#include "../../Property.hpp"
#include "../../rtt-detail-fwd.hpp"

using namespace RTT;
using namespace RTT::detail;
using namespace std;

// Implementation skeleton constructor
RTT_corba_CConfigurationInterface_i::RTT_corba_CConfigurationInterface_i (ConfigurationInterface* ar, PortableServer::POA_ptr the_poa)
    :mar (ar), mbag(0), mpoa( PortableServer::POA::_duplicate(the_poa))
{
}

RTT_corba_CConfigurationInterface_i::RTT_corba_CConfigurationInterface_i (PropertyBag* bag, PortableServer::POA_ptr the_poa)
    :mar (0), mbag(bag), mpoa( PortableServer::POA::_duplicate(the_poa))
{
}

PortableServer::POA_ptr RTT_corba_CConfigurationInterface_i::_default_POA()
{
    return PortableServer::POA::_duplicate(mpoa);
}

// Implementation skeleton destructor
RTT_corba_CConfigurationInterface_i::~RTT_corba_CConfigurationInterface_i (void)
{
    // if no ConfigurationInterface, it must have been a PropertyBag.
    if ( mar == 0 )
        delete mbag;
}

::RTT::base::DataSourceBase::shared_ptr RTT_corba_CConfigurationInterface_i::getPropertyDataSource(const std::string& value_name)
{
    if (!mar)
        return DataSourceBase::shared_ptr();
    if ( findProperty( *mar->properties(), value_name) )
        return findProperty( *mar->properties(), value_name)->getDataSource();
    return DataSourceBase::shared_ptr();
}

::RTT::base::DataSourceBase::shared_ptr RTT_corba_CConfigurationInterface_i::getAttributeDataSource(const std::string& value_name)
{
    if (!mar)
        return DataSourceBase::shared_ptr();
    if ( mar->getAttribute(value_name) )
        return mar->getAttribute(value_name)->getDataSource();
    return DataSourceBase::shared_ptr();
}

::RTT::corba::CConfigurationInterface::CAttributeNames * RTT_corba_CConfigurationInterface_i::getAttributeList (
    void)
{
    ::RTT::corba::CConfigurationInterface::CAttributeNames_var ret = new ::RTT::corba::CConfigurationInterface::CAttributeNames();
    if ( !mar )
        return ret._retn();
    vector<string> names = mar->getAttributeNames();
    ret->length( names.size() );
    for(size_t i=0; i != names.size(); ++i)
    {
        base::DataSourceBase::shared_ptr ds = getAttributeDataSource(names[i]);
        ret[i].name = CORBA::string_dup( names[i].c_str() );
        ret[i].type_name = CORBA::string_dup( ds->getTypeName().c_str() );
        ret[i].assignable = ds->isAssignable();
    }
    return ret._retn();
}

::RTT::corba::CConfigurationInterface::CPropertyNames * RTT_corba_CConfigurationInterface_i::getPropertyList (
    void)
{
    ::RTT::corba::CConfigurationInterface::CPropertyNames_var ret = new ::RTT::corba::CConfigurationInterface::CPropertyNames();
    if (mar)
        mbag = mar->properties();

    vector<string> allprops = listProperties( *mbag );
    vector<string> alldescs = listPropertyDescriptions( *mbag );

    ret->length( allprops.size() );
    vector<string>::iterator it = allprops.begin();
    vector<string>::iterator dit = alldescs.begin();
    size_t index = 0;
    for( ; it != allprops.end(); ++it, ++index, ++dit) {
        ::RTT::corba::CConfigurationInterface::CProperty prop;
        prop.name = CORBA::string_dup( it->c_str() );
        prop.description = CORBA::string_dup( dit->c_str() );
        prop.type_name = getPropertyType((*it).c_str());
        ret[index] = prop;
    }
    return ret._retn();
}

::CORBA::Any * RTT_corba_CConfigurationInterface_i::getAttribute (
    const char * name)
{
    if ( !mar || !mar->hasAttribute( string(name) ) )
        return new CORBA::Any();
    DataSourceBase::shared_ptr ds = mar->getValue( string(name) )->getDataSource();
    const TypeInfo* ti = ds->getTypeInfo();
    CorbaTypeTransporter* ctt = dynamic_cast<CorbaTypeTransporter*>( ti->getProtocol(ORO_CORBA_PROTOCOL_ID) );
    assert( ctt );
    try {
        return ctt->createAny( ds );
    } catch(std::exception const& e) {
        throw StdException(e.what());
    }
}

::CORBA::Boolean RTT_corba_CConfigurationInterface_i::setAttribute (
    const char * name,
    const ::CORBA::Any & value)
{
    if ( !mar || !mar->hasAttribute( string(name) ) )
        return 0;
    DataSourceBase::shared_ptr ds = mar->getValue( string(name) )->getDataSource();
    const TypeInfo* ti = ds->getTypeInfo();
    CorbaTypeTransporter* ctt = dynamic_cast<CorbaTypeTransporter*>( ti->getProtocol(ORO_CORBA_PROTOCOL_ID) );
    assert( ctt );
    return ctt->updateFromAny( &value, ds );
}

::CORBA::Any * RTT_corba_CConfigurationInterface_i::getProperty (
    const char * name)
{
    if (mar)
        mbag = mar->properties(); // leave this here to get latest propertybag.
    if ( mbag == 0 )
        return new CORBA::Any();
    DataSourceBase::shared_ptr ds = getPropertyDataSource(name);
    if ( !ds ) {
        log(Error) <<"CConfigurationInterface: no such property: " << name << ". Returning empty CORBA::Any."<<endlog();
        return new CORBA::Any();
    }
    const TypeInfo* ti = ds->getTypeInfo();
    CorbaTypeTransporter* ctt = dynamic_cast<CorbaTypeTransporter*>( ti->getProtocol(ORO_CORBA_PROTOCOL_ID) );
    assert( ctt );
    try {
        return ctt->createAny( ds );
    } catch(std::exception const& e) {
        throw StdException(e.what());
    }
}

::CORBA::Boolean RTT_corba_CConfigurationInterface_i::setProperty (
    const char * name,
    const ::CORBA::Any & value)
{
    if (mar)
        mbag = mar->properties(); // leave this here to get latest propertybag.
    DataSourceBase::shared_ptr ds = getPropertyDataSource(name);
    if ( !ds )
        return 0;
    const TypeInfo* ti = ds->getTypeInfo();
    CorbaTypeTransporter* ctt = dynamic_cast<CorbaTypeTransporter*>( ti->getProtocol(ORO_CORBA_PROTOCOL_ID) );
    assert( ctt );
    return ctt->updateFromAny( &value, ds );
}

CORBA::Boolean RTT_corba_CConfigurationInterface_i::hasAttribute (
    const char * name)
{
    return mar->hasAttribute( name );
}

CORBA::Boolean RTT_corba_CConfigurationInterface_i::isAttributeAssignable (
    const char * name)
{
    if (mar->getValue(name))
        return mar->getValue(name)->getDataSource()->isAssignable();
    return 0;
}
char * RTT_corba_CConfigurationInterface_i::getAttributeType (
    const char * name)
{
    DataSourceBase::shared_ptr ds = getAttributeDataSource( name );
    if (ds)
        return CORBA::string_dup( ds->getType().c_str() );
    return CORBA::string_dup( "na" );
}

char * RTT_corba_CConfigurationInterface_i::getAttributeTypeName (
    const char * name)
{
    DataSourceBase::shared_ptr ds = getAttributeDataSource( name );
    if (ds)
        return CORBA::string_dup( ds->getTypeName().c_str() );
    return CORBA::string_dup( "na" );
}

char * RTT_corba_CConfigurationInterface_i::attributeToString (
    const char * name)
{
    DataSourceBase::shared_ptr ds = getAttributeDataSource( name );
    if (ds) {
        std::string result = ds->toString();
        return CORBA::string_dup( result.c_str() );
    }
    return CORBA::string_dup( "na" );
}

CORBA::Boolean RTT_corba_CConfigurationInterface_i::attributeFromString (
    const char* name, const char* value
  )
{
    DataSourceBase::shared_ptr ds = getAttributeDataSource( name );
    if (!ds)
        return false;
    if ( ds->getTypeInfo()->fromString( value, ds ) ) {
        RTT::log(RTT::Error) << "corba::CConfigurationInterface: Could not assign string to "<< ds->getType() <<"." <<RTT::endlog();
        return false;
    }
    return true;
}

CORBA::Boolean RTT_corba_CConfigurationInterface_i::hasProperty (
    const char * name)
{
    // converts result to bool.
    return bool( getPropertyDataSource(name) );
}
char * RTT_corba_CConfigurationInterface_i::getPropertyType (
    const char * name)
{
    DataSourceBase::shared_ptr ds = getPropertyDataSource( name );
    if (ds)
        return CORBA::string_dup( ds->getType().c_str() );
    return CORBA::string_dup( "na" );
}

char * RTT_corba_CConfigurationInterface_i::getPropertyTypeName (
    const char * name)
{
    DataSourceBase::shared_ptr ds = getPropertyDataSource( name );
    if (ds)
        return CORBA::string_dup( ds->getTypeName().c_str() );
    return CORBA::string_dup( "na" );
}

char * RTT_corba_CConfigurationInterface_i::propertyToString (
    const char * name)
{
    DataSourceBase::shared_ptr ds = getPropertyDataSource( name );
    if (ds) {
        std::string result = ds->toString();
        return CORBA::string_dup( result.c_str() );
    }
    return CORBA::string_dup( "na" );
}

CORBA::Boolean RTT_corba_CConfigurationInterface_i::propertyFromString (
    const char* name, const char* value
  )
{
    DataSourceBase::shared_ptr ds = getPropertyDataSource( name );
    if (!ds)
        return false;
    if ( ds->getTypeInfo()->fromString( value, ds ) ) {
        RTT::log(RTT::Error) << "corba::CConfigurationInterface: Could not assign string to "<< ds->getType() <<"." <<RTT::endlog();
        return false;
    }
    return true;
}


