/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class OWLDataUtil {
    private static final IRI INT_URI = XSDVocabulary.INT.getIRI();
    private static final Map<Class<?>, XSDVocabulary> numberTypeMap = new HashMap();

    public static OWLDatatype getIntDatatype(OWLDataFactory dataFactory) {
        return dataFactory.getOWLDatatype(INT_URI);
    }

    public static OWLDatatype getLongDatatype(OWLDataFactory dataFactory) {
        return dataFactory.getOWLDatatype(XSDVocabulary.LONG.getIRI());
    }

    public static OWLDatatype getFloatDatatype(OWLDataFactory dataFactory) {
        return dataFactory.getOWLDatatype(XSDVocabulary.FLOAT.getIRI());
    }

    public static OWLDatatype getDoubleDatatype(OWLDataFactory dataFactory) {
        return dataFactory.getOWLDatatype(XSDVocabulary.DOUBLE.getIRI());
    }

    public static <N extends Number> OWLDatatype getDatatype(OWLDataFactory dataFactory, N n) {
        XSDVocabulary v = numberTypeMap.get(n.getClass());
        if (v == null) {
            throw new OWLRuntimeException("Don't know how to translate " + n.getClass());
        }
        return dataFactory.getOWLDatatype(v.getIRI());
    }

    public static Set<OWLFacetRestriction> getFacetRestrictionSet(OWLDataFactory dataFactory, OWLFacet facet, OWLLiteral facetValue) {
        return Collections.singleton(dataFactory.getOWLFacetRestriction(facet, facetValue));
    }

    public static <N extends Number> OWLLiteral getTypedConstant(OWLDataFactory dataFactory, N val) {
        return dataFactory.getOWLLiteral(val.toString(), OWLDataUtil.getDatatype(dataFactory, val));
    }

    public static <N extends Number> OWLDataRange getMinInclusiveRestrictedInt(OWLDataFactory dataFactory, N minInclusive) {
        return dataFactory.getOWLDatatypeRestriction(OWLDataUtil.getDatatype(dataFactory, minInclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLFacet.MIN_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minInclusive)));
    }

    public static <N extends Number> OWLDataRange getMinExclusiveRestrictedInt(OWLDataFactory dataFactory, N minExclusive) {
        return dataFactory.getOWLDatatypeRestriction(OWLDataUtil.getDatatype(dataFactory, minExclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLFacet.MIN_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minExclusive)));
    }

    public static <N extends Number> OWLDataRange getMaxInclusiveRestrictedInteger(OWLDataFactory dataFactory, N maxInclusive) {
        return dataFactory.getOWLDatatypeRestriction(OWLDataUtil.getDatatype(dataFactory, maxInclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLFacet.MAX_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxInclusive)));
    }

    public static <N extends Number> OWLDataRange getMaxExclusiveRestrictedInteger(OWLDataFactory dataFactory, N maxExclusive) {
        return dataFactory.getOWLDatatypeRestriction(OWLDataUtil.getDatatype(dataFactory, maxExclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLFacet.MAX_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxExclusive)));
    }

    public static <N extends Number> OWLDataRange getMinMaxInclusiveRestrictedInteger(OWLDataFactory dataFactory, N minInclusive, N maxInclusive) {
        OWLDatatype dr = OWLDataUtil.getDatatype(dataFactory, minInclusive);
        HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
        facetRestrictions.add(dataFactory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minInclusive)));
        facetRestrictions.add(dataFactory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxInclusive)));
        return dataFactory.getOWLDatatypeRestriction(dr, facetRestrictions);
    }

    public static <N extends Number> OWLDataRange getMinMaxExclusiveRestrictedInteger(OWLDataFactory dataFactory, N minExclusive, N maxExclusive) {
        OWLDatatype dr = OWLDataUtil.getDatatype(dataFactory, minExclusive);
        HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
        facetRestrictions.add(dataFactory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minExclusive)));
        facetRestrictions.add(dataFactory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxExclusive)));
        return dataFactory.getOWLDatatypeRestriction(dr, facetRestrictions);
    }

    static {
        numberTypeMap.put(Byte.class, XSDVocabulary.BYTE);
        numberTypeMap.put(Double.class, XSDVocabulary.DOUBLE);
        numberTypeMap.put(Float.class, XSDVocabulary.FLOAT);
        numberTypeMap.put(Integer.class, XSDVocabulary.INT);
        numberTypeMap.put(Short.class, XSDVocabulary.SHORT);
    }
}

