/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

public class DLExpressivityChecker
implements OWLObjectVisitor {
    private Set<Construct> constructs;
    private Set<OWLOntology> ontologies;

    public List<Construct> getConstructs() throws OWLException {
        return this.getOrderedConstructs();
    }

    public DLExpressivityChecker(Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
        this.constructs = new HashSet<Construct>();
    }

    public String getDescriptionLogicName() {
        List<Construct> orderedConstructs = this.getOrderedConstructs();
        StringBuilder s = new StringBuilder();
        for (Construct c : orderedConstructs) {
            s.append((Object)c);
        }
        return s.toString();
    }

    private void pruneConstructs() {
        if (this.constructs.contains((Object)Construct.AL)) {
            if (this.constructs.contains((Object)Construct.C)) {
                this.constructs.remove((Object)Construct.E);
                this.constructs.remove((Object)Construct.U);
            } else if (this.constructs.contains((Object)Construct.E) && this.constructs.contains((Object)Construct.U)) {
                this.constructs.add(Construct.AL);
                this.constructs.add(Construct.C);
                this.constructs.remove((Object)Construct.E);
                this.constructs.remove((Object)Construct.U);
            }
        }
        if (this.constructs.contains((Object)Construct.N) || this.constructs.contains((Object)Construct.Q)) {
            this.constructs.remove((Object)Construct.F);
        }
        if (this.constructs.contains((Object)Construct.Q)) {
            this.constructs.remove((Object)Construct.N);
        }
        if (this.constructs.contains((Object)Construct.AL) && this.constructs.contains((Object)Construct.C) && this.constructs.contains((Object)Construct.TRAN)) {
            this.constructs.remove((Object)Construct.AL);
            this.constructs.remove((Object)Construct.C);
            this.constructs.remove((Object)Construct.TRAN);
            this.constructs.add(Construct.S);
        }
        if (this.constructs.contains((Object)Construct.R)) {
            this.constructs.remove((Object)Construct.H);
        }
    }

    private List<Construct> getOrderedConstructs() {
        this.constructs.clear();
        this.constructs.add(Construct.AL);
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom oWLAxiom : ont.getLogicalAxioms()) {
                oWLAxiom.accept(this);
            }
        }
        this.pruneConstructs();
        ArrayList<Construct> cons = new ArrayList<Construct>(this.constructs);
        Collections.sort(cons, new ConstructComparator());
        return cons;
    }

    @Override
    public void visit(OWLObjectProperty property) {
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.constructs.add(Construct.I);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDatatype node) {
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLLiteral node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLClass desc) {
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.constructs.add(Construct.AL);
        for (OWLClassExpression operands : desc.getOperands()) {
            operands.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.constructs.add(Construct.U);
        for (OWLClassExpression operands : desc.getOperands()) {
            operands.accept(this);
        }
    }

    private boolean isTop(OWLClassExpression classExpression) {
        return classExpression.isOWLThing();
    }

    private boolean isAtomic(OWLClassExpression classExpression) {
        if (classExpression.isAnonymous()) {
            return false;
        }
        for (OWLOntology ont : this.ontologies) {
            if (ont.getAxioms((OWLClass)classExpression).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        if (this.isAtomic(desc)) {
            this.constructs.add(Construct.AL);
        } else {
            this.constructs.add(Construct.C);
        }
        desc.getOperand().accept(this);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom desc) {
        if (this.isTop((OWLClassExpression)desc.getFiller())) {
            this.constructs.add(Construct.AL);
        } else {
            this.constructs.add(Construct.E);
        }
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom desc) {
        this.constructs.add(Construct.AL);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectHasValue desc) {
        this.constructs.add(Construct.O);
        this.constructs.add(Construct.E);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
    }

    private void checkCardinality(OWLDataCardinalityRestriction restriction) {
        if (restriction.isQualified()) {
            this.constructs.add(Construct.Q);
        } else {
            this.constructs.add(Construct.N);
        }
        ((OWLDataRange)restriction.getFiller()).accept(this);
        ((OWLDataPropertyExpression)restriction.getProperty()).accept(this);
    }

    private void checkCardinality(OWLObjectCardinalityRestriction restriction) {
        if (restriction.isQualified()) {
            this.constructs.add(Construct.Q);
        } else {
            this.constructs.add(Construct.N);
        }
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.constructs.add(Construct.R);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.O);
    }

    @Override
    public void visit(OWLDataSomeValuesFrom desc) {
        this.constructs.add(Construct.E);
        ((OWLDataRange)desc.getFiller()).accept(this);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataAllValuesFrom desc) {
        ((OWLDataRange)desc.getFiller()).accept(this);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataHasValue desc) {
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinality desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLDataExactCardinality desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLDataMaxCardinality desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.constructs.add(Construct.C);
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        axiom.getDomain().accept(this);
        this.constructs.add(Construct.AL);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.constructs.add(Construct.AL);
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.H);
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.O);
        this.constructs.add(Construct.C);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.constructs.add(Construct.D);
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.R);
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.constructs.add(Construct.AL);
        ((OWLClassExpression)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.constructs.add(Construct.H);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.C);
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.I);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.constructs.add(Construct.AL);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.constructs.add(Construct.F);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.constructs.add(Construct.H);
        this.constructs.add(Construct.D);
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getClassExpression().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.TRAN);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.constructs.add(Construct.H);
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.I);
        this.constructs.add(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.constructs.add(Construct.O);
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.constructs.add(Construct.R);
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.I);
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
    }

    @Override
    public void visit(OWLDataUnionOf node) {
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
    }

    @Override
    public void visit(OWLAnnotation annotation) {
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
    }

    @Override
    public void visit(IRI iri) {
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    @Override
    public void visit(SWRLVariable node) {
    }

    @Override
    public void visit(OWLOntology ontology) {
    }

    @Override
    public void visit(SWRLClassAtom node) {
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
    }

    private static class ConstructComparator
    implements Comparator<Construct> {
        private final List<Construct> order = new ArrayList<Construct>();

        public ConstructComparator() {
            this.order.add(Construct.S);
            this.order.add(Construct.AL);
            this.order.add(Construct.C);
            this.order.add(Construct.U);
            this.order.add(Construct.E);
            this.order.add(Construct.R);
            this.order.add(Construct.H);
            this.order.add(Construct.O);
            this.order.add(Construct.I);
            this.order.add(Construct.N);
            this.order.add(Construct.Q);
            this.order.add(Construct.F);
            this.order.add(Construct.TRAN);
            this.order.add(Construct.D);
        }

        @Override
        public int compare(Construct o1, Construct o2) {
            return this.order.indexOf((Object)o1) - this.order.indexOf((Object)o2);
        }
    }

    public static enum Construct {
        AL("AL"),
        U("U"),
        C("C"),
        E("E"),
        N("N"),
        Q("Q"),
        H("H"),
        I("I"),
        O("O"),
        F("F"),
        TRAN("+"),
        D("(D)"),
        R("R"),
        S("S"),
        EL("EL"),
        ELPLUSPLUS("EL++");

        private String s;

        private Construct(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

