/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class GZipFileDocumentSource
implements OWLOntologyDocumentSource {
    private static int counter = 0;
    private final IRI documentIRI;
    private final File file;

    public GZipFileDocumentSource(File is) {
        this(is, GZipFileDocumentSource.getNextDocumentIRI());
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("file:ontology" + ++counter);
    }

    public GZipFileDocumentSource(File stream, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.file = stream;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new GZIPInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new OWLRuntimeException("File not found - check that the file is available before calling this method.");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return this.file.exists();
    }
}

