SET(GDAL_FOUND FALSE)
FIND_PROGRAM(GDAL_GDAL_CONFIG_EXECUTABLE NAMES gdal-config)

IF(GDAL_GDAL_CONFIG_EXECUTABLE)
    SET(GDAL_FOUND TRUE)

    EXECUTE_PROCESS(COMMAND ${GDAL_GDAL_CONFIG_EXECUTABLE} --cflags
        OUTPUT_VARIABLE GDAL_CFLAGS)
    STRING(REPLACE "\n" "" GDAL_CFLAGS ${GDAL_CFLAGS})

    EXECUTE_PROCESS(COMMAND ${GDAL_GDAL_CONFIG_EXECUTABLE} --libs
        OUTPUT_VARIABLE GDAL_LIBRARIES)
    STRING(REPLACE "\n" "" GDAL_LIBRARIES ${GDAL_LIBRARIES})

    MARK_AS_ADVANCED(GDAL_CFLAGS GDAL_LIBRARIES)
ENDIF()

IF (GDAL_FOUND)
    IF (NOT GDAL_FIND_QUIETLY)
	MESSAGE(STATUS "Found the GDAL library")
    ENDIF(NOT GDAL_FIND_QUIETLY)
ELSE (GDAL_FOUND)
    IF (GDAL_FIND_REQUIRED)
	MESSAGE(FATAL_ERROR "Please install the GDAL library")
    ENDIF(GDAL_FIND_REQUIRED)
ENDIF(GDAL_FOUND)


