/*
 * Decompiled with CFR 0.152.
 */
package com.advancednavigation.anppExample;

import com.advancednavigation.anPackets.ANPacket;
import com.advancednavigation.anPackets.ANPacket20;
import com.advancednavigation.anPackets.ANPacket28;
import com.advancednavigation.anPackets.ANPacketDecoder;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class Main {
    private JFrame frmAnppExample;
    private JComboBox comboBoxPort;
    private JComboBox comboBoxBaud;
    private JButton btnConnect;
    private SerialPort serialPort;
    protected Boolean serialConnected = false;
    private Boolean serialPortsAvailable = false;
    private JTextArea textArea;
    private JPanel panel;
    private JLabel lblLatitude;
    private JLabel lblLongitude;
    private JLabel lblHeight;
    protected JTextField textFieldLatitude;
    protected JTextField textFieldLongitude;
    protected JTextField textFieldHeight;
    private JLabel lblRoll;
    private JLabel lblPitch;
    private JLabel lblYaw;
    protected JTextField textFieldRoll;
    protected JTextField textFieldPitch;
    protected JTextField textFieldYaw;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main window = new Main();
                    window.frmAnppExample.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Main() {
        this.initialize();
    }

    private void initialize() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frmAnppExample = new JFrame();
        this.frmAnppExample.setTitle("ANPP Example");
        this.frmAnppExample.setBounds(100, 100, 819, 631);
        this.frmAnppExample.setDefaultCloseOperation(3);
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 10;
        nArray[3] = 90;
        nArray[4] = 5;
        gridBagLayout.columnWidths = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 10;
        nArray2[4] = 5;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.frmAnppExample.getContentPane().setLayout(gridBagLayout);
        this.comboBoxPort = new JComboBox();
        this.comboBoxPort.setModel(new DefaultComboBoxModel<String>(new String[]{"No Serial Ports"}));
        GridBagConstraints gbc_comboBoxPort = new GridBagConstraints();
        gbc_comboBoxPort.insets = new Insets(0, 0, 5, 5);
        gbc_comboBoxPort.fill = 2;
        gbc_comboBoxPort.gridx = 1;
        gbc_comboBoxPort.gridy = 1;
        this.frmAnppExample.getContentPane().add((Component)this.comboBoxPort, gbc_comboBoxPort);
        this.comboBoxBaud = new JComboBox();
        this.comboBoxBaud.setModel(new DefaultComboBoxModel<String>(new String[]{"1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200", "230400", "460800", "500000", "921600", "1000000"}));
        this.comboBoxBaud.setSelectedIndex(7);
        GridBagConstraints gbc_comboBoxBaud = new GridBagConstraints();
        gbc_comboBoxBaud.insets = new Insets(0, 0, 5, 5);
        gbc_comboBoxBaud.fill = 2;
        gbc_comboBoxBaud.gridx = 2;
        gbc_comboBoxBaud.gridy = 1;
        this.frmAnppExample.getContentPane().add((Component)this.comboBoxBaud, gbc_comboBoxBaud);
        this.btnConnect = new JButton("Connect");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!Main.this.serialConnected.booleanValue()) {
                    try {
                        Main.this.serialPort = new SerialPort((String)Main.this.comboBoxPort.getSelectedItem());
                        Main.this.serialPort.openPort();
                        Main.this.serialPort.setParams(Integer.parseInt((String)Main.this.comboBoxBaud.getSelectedItem()), 8, 1, 0);
                        Main.this.serialPort.setEventsMask(1);
                        Main.this.serialPort.addEventListener(new SerialReader());
                        Main.this.btnConnect.setText("Disconnect");
                        Main.this.serialConnected = true;
                        Main.this.comboBoxPort.setEnabled(false);
                        Main.this.comboBoxBaud.setEnabled(false);
                    }
                    catch (Exception exception) {
                        System.err.println(exception.toString());
                        Main.this.serialPortClose();
                    }
                } else {
                    Main.this.serialPortClose();
                }
            }
        });
        GridBagConstraints gbc_btnConnect = new GridBagConstraints();
        gbc_btnConnect.fill = 2;
        gbc_btnConnect.insets = new Insets(0, 0, 5, 5);
        gbc_btnConnect.gridx = 3;
        gbc_btnConnect.gridy = 1;
        this.frmAnppExample.getContentPane().add((Component)this.btnConnect, gbc_btnConnect);
        this.panel = new JPanel();
        this.panel.setBorder(new TitledBorder(null, "Data", 4, 2, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.gridwidth = 3;
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 2;
        this.frmAnppExample.getContentPane().add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        int[] nArray3 = new int[8];
        nArray3[0] = 10;
        nArray3[3] = 5;
        nArray3[5] = 5;
        gbl_panel.columnWidths = nArray3;
        int[] nArray4 = new int[6];
        nArray4[0] = 5;
        nArray4[4] = 5;
        gbl_panel.rowHeights = nArray4;
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.lblLatitude = new JLabel("Latitude:");
        GridBagConstraints gbc_lblLatitude = new GridBagConstraints();
        gbc_lblLatitude.anchor = 13;
        gbc_lblLatitude.insets = new Insets(0, 0, 5, 5);
        gbc_lblLatitude.gridx = 1;
        gbc_lblLatitude.gridy = 1;
        this.panel.add((Component)this.lblLatitude, gbc_lblLatitude);
        this.textFieldLatitude = new JTextField();
        GridBagConstraints gbc_textFieldLatitude = new GridBagConstraints();
        gbc_textFieldLatitude.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldLatitude.fill = 2;
        gbc_textFieldLatitude.gridx = 2;
        gbc_textFieldLatitude.gridy = 1;
        this.panel.add((Component)this.textFieldLatitude, gbc_textFieldLatitude);
        this.textFieldLatitude.setColumns(15);
        this.lblRoll = new JLabel("Roll:");
        GridBagConstraints gbc_lblRoll = new GridBagConstraints();
        gbc_lblRoll.anchor = 13;
        gbc_lblRoll.insets = new Insets(0, 0, 5, 5);
        gbc_lblRoll.gridx = 4;
        gbc_lblRoll.gridy = 1;
        this.panel.add((Component)this.lblRoll, gbc_lblRoll);
        this.textFieldRoll = new JTextField();
        GridBagConstraints gbc_textFieldRoll = new GridBagConstraints();
        gbc_textFieldRoll.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldRoll.fill = 2;
        gbc_textFieldRoll.gridx = 5;
        gbc_textFieldRoll.gridy = 1;
        this.panel.add((Component)this.textFieldRoll, gbc_textFieldRoll);
        this.textFieldRoll.setColumns(15);
        this.lblLongitude = new JLabel("Longitude:");
        GridBagConstraints gbc_lblLongitude = new GridBagConstraints();
        gbc_lblLongitude.anchor = 13;
        gbc_lblLongitude.insets = new Insets(0, 0, 5, 5);
        gbc_lblLongitude.gridx = 1;
        gbc_lblLongitude.gridy = 2;
        this.panel.add((Component)this.lblLongitude, gbc_lblLongitude);
        this.textFieldLongitude = new JTextField();
        GridBagConstraints gbc_textFieldLongitude = new GridBagConstraints();
        gbc_textFieldLongitude.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldLongitude.fill = 2;
        gbc_textFieldLongitude.gridx = 2;
        gbc_textFieldLongitude.gridy = 2;
        this.panel.add((Component)this.textFieldLongitude, gbc_textFieldLongitude);
        this.textFieldLongitude.setColumns(15);
        this.lblPitch = new JLabel("Pitch:");
        GridBagConstraints gbc_lblPitch = new GridBagConstraints();
        gbc_lblPitch.anchor = 13;
        gbc_lblPitch.insets = new Insets(0, 0, 5, 5);
        gbc_lblPitch.gridx = 4;
        gbc_lblPitch.gridy = 2;
        this.panel.add((Component)this.lblPitch, gbc_lblPitch);
        this.textFieldPitch = new JTextField();
        GridBagConstraints gbc_textFieldPitch = new GridBagConstraints();
        gbc_textFieldPitch.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldPitch.fill = 2;
        gbc_textFieldPitch.gridx = 5;
        gbc_textFieldPitch.gridy = 2;
        this.panel.add((Component)this.textFieldPitch, gbc_textFieldPitch);
        this.textFieldPitch.setColumns(15);
        this.lblHeight = new JLabel("Height:");
        GridBagConstraints gbc_lblHeight = new GridBagConstraints();
        gbc_lblHeight.anchor = 13;
        gbc_lblHeight.insets = new Insets(0, 0, 5, 5);
        gbc_lblHeight.gridx = 1;
        gbc_lblHeight.gridy = 3;
        this.panel.add((Component)this.lblHeight, gbc_lblHeight);
        this.textFieldHeight = new JTextField();
        GridBagConstraints gbc_textFieldHeight = new GridBagConstraints();
        gbc_textFieldHeight.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldHeight.fill = 2;
        gbc_textFieldHeight.gridx = 2;
        gbc_textFieldHeight.gridy = 3;
        this.panel.add((Component)this.textFieldHeight, gbc_textFieldHeight);
        this.textFieldHeight.setColumns(15);
        this.lblYaw = new JLabel("Yaw:");
        GridBagConstraints gbc_lblYaw = new GridBagConstraints();
        gbc_lblYaw.anchor = 13;
        gbc_lblYaw.insets = new Insets(0, 0, 5, 5);
        gbc_lblYaw.gridx = 4;
        gbc_lblYaw.gridy = 3;
        this.panel.add((Component)this.lblYaw, gbc_lblYaw);
        this.textFieldYaw = new JTextField();
        GridBagConstraints gbc_textFieldYaw = new GridBagConstraints();
        gbc_textFieldYaw.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldYaw.fill = 2;
        gbc_textFieldYaw.gridx = 5;
        gbc_textFieldYaw.gridy = 3;
        this.panel.add((Component)this.textFieldYaw, gbc_textFieldYaw);
        this.textFieldYaw.setColumns(15);
        this.textArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        GridBagConstraints gbc_textArea = new GridBagConstraints();
        gbc_textArea.gridwidth = 3;
        gbc_textArea.insets = new Insets(0, 0, 5, 5);
        gbc_textArea.fill = 1;
        gbc_textArea.gridx = 1;
        gbc_textArea.gridy = 3;
        this.frmAnppExample.getContentPane().add((Component)scrollPane, gbc_textArea);
        Thread portScannerThread = new Thread(new PortScanner());
        portScannerThread.start();
    }

    private void serialPortClose() {
        try {
            this.serialPort.removeEventListener();
            this.serialPort.closePort();
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
        this.btnConnect.setText("Connect");
        this.serialConnected = false;
        this.comboBoxPort.setEnabled(true);
        this.comboBoxBaud.setEnabled(true);
    }

    public class PortScanner
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                if (!Main.this.serialConnected.booleanValue()) {
                    final String[] portNames = SerialPortList.getPortNames();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!((PortScanner)PortScanner.this).Main.this.serialConnected.booleanValue()) {
                                int comboLength = Main.this.comboBoxPort.getItemCount();
                                if (!Main.this.serialPortsAvailable.booleanValue()) {
                                    comboLength = 0;
                                }
                                if (portNames.length != comboLength) {
                                    Main.this.comboBoxPort.removeAllItems();
                                    int i = 0;
                                    while (i < portNames.length) {
                                        Main.this.comboBoxPort.addItem(portNames[i]);
                                        ++i;
                                    }
                                    if (portNames.length == 0) {
                                        Main.this.comboBoxPort.addItem("No Serial Ports");
                                        Main.this.comboBoxPort.setSelectedIndex(0);
                                        Main.this.comboBoxPort.setEnabled(false);
                                        Main.this.btnConnect.setEnabled(false);
                                        Main.this.serialPortsAvailable = false;
                                    } else {
                                        Main.this.comboBoxPort.setSelectedIndex(0);
                                        Main.this.comboBoxPort.setEnabled(true);
                                        Main.this.btnConnect.setEnabled(true);
                                        Main.this.serialPortsAvailable = true;
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class SerialReader
    implements SerialPortEventListener {
        ANPacketDecoder packetDecoder = new ANPacketDecoder();

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR()) {
                try {
                    byte[] buffer = Main.this.serialPort.readBytes();
                    if (buffer != null) {
                        int i = 0;
                        while (i < buffer.length) {
                            if (this.packetDecoder.bufferLength < this.packetDecoder.buffer.length) {
                                this.packetDecoder.buffer[this.packetDecoder.bufferLength++] = buffer[i];
                            }
                            ++i;
                        }
                        ANPacket packet = null;
                        while ((packet = this.packetDecoder.packetDecode()) != null) {
                            switch (packet.id) {
                                case 28: {
                                    if (packet.length != 48) break;
                                    ANPacket28 anPacket28 = new ANPacket28(packet);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            Main.this.textArea.append("Received Raw Sensors Packet\n");
                                            Main.this.textArea.setCaretPosition(Main.this.textArea.getDocument().getLength());
                                        }
                                    });
                                    break;
                                }
                                case 20: {
                                    if (packet.length != 100) break;
                                    final ANPacket20 anPacket20 = new ANPacket20(packet);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            Main.this.textArea.append("Received System State Packet\n");
                                            Main.this.textArea.setCaretPosition(Main.this.textArea.getDocument().getLength());
                                            ((SerialReader)SerialReader.this).Main.this.textFieldLatitude.setText(Double.toString(anPacket20.position[0] * 180.0 / Math.PI));
                                            ((SerialReader)SerialReader.this).Main.this.textFieldLongitude.setText(Double.toString(anPacket20.position[1] * 180.0 / Math.PI));
                                            ((SerialReader)SerialReader.this).Main.this.textFieldHeight.setText(Double.toString(anPacket20.position[2]));
                                            ((SerialReader)SerialReader.this).Main.this.textFieldRoll.setText(Double.toString((double)(anPacket20.orientation[0] * 180.0f) / Math.PI));
                                            ((SerialReader)SerialReader.this).Main.this.textFieldPitch.setText(Double.toString((double)(anPacket20.orientation[1] * 180.0f) / Math.PI));
                                            ((SerialReader)SerialReader.this).Main.this.textFieldYaw.setText(Double.toString((double)(anPacket20.orientation[2] * 180.0f) / Math.PI));
                                        }
                                    });
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (SerialPortException exception) {
                    System.err.println(exception.toString());
                }
            }
        }
    }
}

