/*
 * Decompiled with CFR 0.152.
 */
package com.advancednavigation.anPackets;

import com.advancednavigation.anPackets.ANPacket;
import com.advancednavigation.anPackets.TypeConversion;

public class ANPacket31 {
    public int gpsSatellites = 0;
    public int glonassSatellites = 0;
    public int sbasSatellites = 0;
    public int compassSatellites = 0;
    public int galileoSatellites = 0;
    public Satellite[] satellites;

    public ANPacket31() {
        this.satellites = new Satellite[0];
    }

    public ANPacket31(ANPacket packet) {
        this.satellites = new Satellite[packet.length / 7];
        int i = 0;
        while (i < this.satellites.length) {
            this.satellites[i] = new Satellite();
            this.satellites[i].navigationSystem = packet.data[7 * i] & 0xFF;
            this.satellites[i].number = packet.data[7 * i + 1] & 0xFF;
            this.satellites[i].frequency = packet.data[7 * i + 2];
            this.satellites[i].elevation = packet.data[7 * i + 3] & 0xFF;
            this.satellites[i].azimuth = TypeConversion.bytesToUInt16(packet.data, 7 * i + 4);
            this.satellites[i].snr = packet.data[7 * i + 6] & 0xFF;
            if (this.satellites[i].navigationSystem == 1) {
                ++this.gpsSatellites;
            } else if (this.satellites[i].navigationSystem == 2) {
                ++this.glonassSatellites;
            } else if (this.satellites[i].navigationSystem == 4) {
                ++this.sbasSatellites;
            } else if (this.satellites[i].navigationSystem == 6) {
                ++this.compassSatellites;
            } else if (this.satellites[i].navigationSystem == 5) {
                ++this.galileoSatellites;
            }
            ++i;
        }
    }

    public class Satellite {
        public int navigationSystem;
        public int number;
        public int frequency;
        public int elevation;
        public int azimuth;
        public int snr;
    }
}

